The first technology that was developed, intrusion detection system **(IDS), had sensing capabilities** but little capability to act on what it detected. An intrusion prevention system **(IPS) builds upon previous IDS** technology.

An **IPS** has the **ability to analyze traffic** from the data link layer to the application layer. For example, an IPS can:

- Examines Layer 2 to Layer 3 mappings, such as ARP and DHCP.
- Ensures compliance with networking protocols like IP, TCP, UDP, and ICMP.
- Inspects application payloads to detect network attacks, malware, and server misconfigurations.

When traffic comes in through an **interface on an IPS**, if that traffic **matches an IPS signature/rule**, then that traffic can be **dropped by the IPS**.

An **IDS** simply **produces alerts** when suspicious traffic is seen. An IDS is not responsible for **mitigating** the threat while **IPS can**. 

**IPS technology** **is deployed** in a sensor, which is described as one of the following:

- An **appliance** that is specifically designed to provide dedicated IPS services. Cisco provides Cisco Secure Firewall Threat Defense devices, which offers many different capabilities, IPS being just one of them.
    
- A **module** that is installed in another network device, such as an adaptive security appliance, a switch, or a router. Cisco provides a **threat defense services module** that can be installed in Cisco Secure ASA.


**Intrusion detection** technology uses different strategies to **detect and mitigate** against attacks:

- **Anomaly Detection**: Learns normal network patterns to create a baseline; detects deviations as suspicious activity.
- **Rule-based Detection**: Analyzes live traffic using a database of IPS rules. **(IPS Signatures**) to identify known attack patterns and techniques.
- **Reputation-based**: Uses reputation filtering to block traffic from known malicious sources before detailed inspection.


Cisco Secure Firewall uses **Snort** **open source IPS.**
![[Pasted image 20250304180259.png]]

The ***Cisco Secure Firewall Threat Defense*** uses Snort versions 2 and 3 which are intrusion prevention systems for network intrusion prevention. **Snort rules also known as intrusion rule**, consisting of specified keywords and arguments, detect vulnerability exploits. Users can create custom rules in addition to the default ones. The system analyzes network traffic, comparing packets to rule conditions and triggering alerts when conditions are met.

**Quiz**: 

In a high-stakes network environment, the battle between intrusion detection and prevention is ongoing. Imagine a corporate network where sensitive information is at risk, and a suspicious packet is detected. What distinctive capability allows an Intrusion Prevention System (IPS) to not only identify but also thwart potential threats in real-time, contrasting it with an Intrusion Detection System (IDS)?

1. **Automated Anomaly Creation**: Instantly generates new anomalies for future attack prediction.
2. **Real-time Traffic Blocking**: Actively stops and blocks malicious traffic as it is detected.
3. **Comprehensive Protocol Logging**: Maintains detailed logs of all protocol activities for later analysis.
4. **Retrospective Alert Generation**: Sends alerts after analyzing historical data for potential threats.

### Correct Answer:

1. **Real-time Traffic Blocking**

### Reason:

An Intrusion Prevention System (IPS) distinguishes itself from an Intrusion Detection System (IDS) by its ability to respond immediately to detected threats. Unlike an IDS, which only generates alerts, an IPS can actively block and stop malicious traffic in real-time, thereby preventing threats from compromising the network. This capability is crucial in maintaining the integrity, confidentiality, and availability (CIA) of information resources.

**Quiz - 2** - 

Which statement describes the primary IPS mechanism that is used in rule-based detection to help stop attackers from compromising systems?

- The geolocation database can be installed to filter specific countries, based on reputation scores.
    
- IPS rulesets evaluate various network activities over a long period, allowing a rule-based detection configuration to automatically update its ruleset.
    
- Rule-based detection, using updated IPS signature files, can be used to stop attackers from malicious activity. (**Correct**)
    
- Complex ACLs can be applied to the WAN-facing interfaces, allowing rule-based detection to inspect traffic as it enters the sensor.
    
- By deploying NAT on WAN-facing interfaces and working with rule-based detection methods, malicious activity can be inspected and blocked before it is sent to internal network resources.

